'use strict';

describe('Component: requestMetricsDashboard', function () {
  beforeEach(module('genisis'));

  var $scope, $rootScope, $api, $user, $location, $window, $q;
  var controller, $componentController;

  beforeEach(inject(function (
    _$rootScope_,
    user,
    api,
    _$location_,
    _$window_,
    _$q_,
    $injector
  ) {
    $rootScope = _$rootScope_;
    $scope = $rootScope.$new();
    $user = user;
    $api = api;
    $location = _$location_;
    $window = _$window_;
    $q = _$q_;
    $componentController = $injector.get('$componentController');
    controller = $componentController('requestMetricsDashboard', {});
  }));
  it('expects ctrl.itemsPerPage to be 25', function () {
    expect(controller.itemsPerPage).toEqual(25);
  });
  it('expects ctrl.possibleSelections to be [25, 50, 75, 100]', function () {
    expect(controller.possibleSelections).toEqual([25, 50, 75, 100]);
  });
  it('expects ctrl.pagedItems to be []', function () {
    expect(controller.pagedItems).toEqual([]);
  });
  it('expects ctrl.currentPage to be 0', function () {
    expect(controller.currentPage).toEqual(0);
  });
  it('expects ctrl.requests to be {}', function () {
    expect(controller.requests).toEqual({});
  });
  it('expects ctrl.havePagedItems to be false', function () {
    expect(controller.havePagedItems).toEqual(false);
  });
  it('expects ctrl.userService to be $user', function () {
    expect(controller.userService).toEqual($user);
  });
  it('expects ctrl.n to be 0', function () {
    expect(controller.n).toEqual(0);
  });
  describe('ctrl.nextPage() function', function () {
    it('exists',
      function () {
        expect(controller.nextPage).toBeDefined();
      });
    it('increments currentPage by 1 but not more than the max',
      function () {
        controller.currentPage = 0;
        controller.pagedItems.length = 2;
        expect(controller.currentPage).toEqual(0);
        controller.nextPage();
        expect(controller.currentPage).toEqual(1);
        controller.nextPage();
        expect(controller.currentPage).toEqual(1);
      });
  });
  describe('ctrl.prevPage() function', function () {
    it('exists',
      function () {
        expect(controller.prevPage).toBeDefined();
      });
    it('decrements currentPage by 1 but not below 0', function () {
      controller.currentPage = 1;
      expect(controller.currentPage).toEqual(1);
      controller.prevPage();
      expect(controller.currentPage).toEqual(0);
      controller.prevPage();
      expect(controller.currentPage).toEqual(0);
    });
  });
  describe('ctrl.setPage() function', function () {
    it('exists',
      function () {
        expect(controller.groupToPages).toBeDefined();
      });
    it('sets currentPage to a specified page', function () {
      controller.currentPage = 0;
      controller.setPage(2);
      expect(controller.currentPage).toEqual(2);
    });
  });
  describe('ctrl.groupToPages() function', function () {
    it('exists',
      function () {
        expect(controller.groupToPages).toBeDefined();
      });
    it('breaks requests up into pages', function () {
      controller.requests = [1, 2, 3];
      controller.itemsPerPage = 2;
      expect(controller.pagedItems).toEqual([]);
      controller.groupToPages();
      expect(controller.pagedItems).toEqual([
        [1, 2],
        [3]
      ]);
    });
  });
  describe('ctrl.fetchRequestsCounts() function', function () {
    it('exists', function () {
      expect(controller.fetchRequestsCounts()).toBeDefined();
    });
    it(
      'expects method promise to call window alert when failed response',
      function () {
        spyOn($window, 'alert');
        spyOn($api, 'retrieve').and.callFake(
          function () {
            var deferred = $q.defer();
            deferred.resolve({
              success: false,
              response: {},
              message: 'test'
            });
            return deferred.promise;
          }
        );
        var promise = controller.fetchRequestsCounts();
        promise.then(function (data) {
          expect(data.success).toEqual(false);
          expect(data.response).toEqual({});
          expect(window.alert).toHaveBeenCalledWith('test');
        });
        expect($api.retrieve.calls.count()).toEqual(1);
      });
    it('expects to get the counts of requests', function () {
      spyOn($api, 'retrieve').and.callFake(function () {
        var deferred = $q.defer();
        deferred.resolve({
          success: true,
          response: {
            count: [{
              count: 1
            }, {
              count: 2
            }, {
              count: 3
            }]
          },
          message: 'test'
        });
        return deferred.promise;
      });
      spyOn($window, 'alert');
      var promise = controller.fetchRequestsCounts();
      promise.then(function (data) {
        expect(controller.count).toEqual(data.response);
      });
      expect($api.retrieve.calls.count()).toEqual(1);
    });
  });

  describe('ctrl.fetchRequestsByStatus() function', function () {
    it('exists', function () {
      expect(controller.fetchRequestsByStatus).toBeDefined();
    });


    it(
      'expects method promise to call window alert when failed response',
      function () {
        spyOn($window, 'alert');
        spyOn($api, 'retrieve').and.callFake(
          function () {
            var deferred = $q.defer();
            deferred.resolve({
              success: false,
              response: {},
              message: 'test'
            });
            return deferred.promise;
          }
        );
        var status = 'test';
        var promise = controller.fetchRequestsByStatus(status);
        promise.then(function (data) {
          expect(data.success).toEqual(false);
          expect(data.response).toEqual({});
          expect($window.alert).toHaveBeenCalledWith('test');
        });
        expect($api.retrieve.calls.count()).toEqual(1);
      });

    it('expects success', function () {
      spyOn($api, 'retrieve').and.callFake(
        function () {
          var deferred = $q.defer();
          deferred.resolve({
            success: true,
            response: {
              requests: [{
                id: 1
              }, {
                id: 2
              }, {
                id: 3
              }]
            },
            message: 'test'
          });
          return deferred.promise;
        }
      );
      var status = 'test';
      var promise = controller.fetchRequestsByStatus(status);
      promise.then(function (data) {
        expect(data.success).toEqual(true);
        expect(data.response).toEqual({
          test: [{
            id: 1
          }, {
            id: 2
          }, {
            id: 3
          }]
        });
        expect(controller.havePagedItems).toEqual(true);
        expect(controller.requests).toEqual({
          requests: [{
            id: 1
          }, {
            id: 2
          }, {
            id: 3
          }]
        });
      });
      expect($api.retrieve.calls.count()).toEqual(1);
    });
  });

  describe('ctrl.range() function', function () {
    it('exists', function () {
      expect(controller.range).toBeDefined();
    });
    it('calculates possible range for pages based on how many pages',
      function () {
        expect(controller.range(3)).toEqual([0, 1, 2]);
      });
  });
  describe('ctrl.onChange() function', function () {
    it('exists', function () {
      expect(controller.onChange).toBeDefined();
    });
    it(
      'updates pages when a possibleSelection is changed and returns you to starting page',
      function () {
        controller.itemsPerPage = 0;
        controller.currentPage = 2;
        controller.onChange(25);
        expect(controller.itemsPerPage).toEqual(25);
        expect(controller.currentPage).toEqual(0);
      });

  });
});